/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.net.URL;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.Utilities;

public class DelegatorApplet
extends AbstractDelegatorApplet {
    protected void handleError(String string, String string2, String string3) {
        Utilities.logPrintln("handleError()");
        Utilities.logPrintln("\t\tadditionalUrlString = " + string);
        Utilities.logPrintln("\t\temergencyMessage = " + string2);
        Utilities.logPrintln("\t\temergencyId = " + string3);
        try {
            URL uRL = new URL(this.getDocumentBase(), "PTGeneralError.action?errortype=" + string);
            Utilities.logPrintln("... myUrl = " + uRL);
            this.getAppletContext().showDocument(uRL);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            if (this.worker != null) {
                try {
                    this.worker.stop();
                }
                catch (Throwable throwable2) {
                    Utilities.checkSwallow(throwable2);
                }
                this.worker = null;
            }
            Utilities.warn(this, "Unable To Continue", "A fatal error prevents you from continuing your assessment.\nPlease report this to your instructor.\n\tMessage: " + string2 + ".\n\tMessage ID: " + string3);
        }
        Utilities.saveBuffer();
        Utilities.logPrintln("\n==> void");
    }

    protected boolean initializationError(Throwable throwable) {
        Utilities.logPrintln("initializationError()");
        Utilities.logPrintln("\t\tt = " + throwable);
        String string = Utilities.toString(throwable);
        Utilities.logPrintln("... stackTrace = " + string);
        this.handleError("ptaplayerinitializationerror&error=" + Utilities.safeEncode(string), "Initialization error: " + string, "AP-DA-006");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnBrowserNameError() {
        Utilities.logPrintln("browserNameError()");
        String string = this.getParameter("browsername");
        String string2 = "browsernameerror&browsername=" + Utilities.safeEncode(string);
        Utilities.logPrintln("... browserName = " + string);
        Utilities.logPrintln("... additionalUrlString = " + string2);
        this.handleError(string2, "Your browser is not supported for Cisco Packet Tracer Skills Assessments.  Review the setup procedure for Packet Tracer Skills Assessments to find supported browsers.", "AP-DA-008");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnJarLoadingError(Throwable throwable) {
        Utilities.logPrintln("jarLoadingError()");
        Utilities.logPrintln("\t\tt = " + throwable);
        String string = Utilities.toString(throwable);
        Utilities.logPrintln("... stackTrace = " + string);
        this.handleError("ptaplayerjarloadingerror&error=" + Utilities.safeEncode(string), "JAR file loading error: " + string, "AP-DA-007");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnJreVersionError() {
        Utilities.logPrintln("jreVersionError()");
        String string = Utilities.getGeneralJavaVersion();
        String string2 = Utilities.getSpecificJavaVersion();
        String string3 = "jreversionproblem&generalversion=" + Utilities.safeEncode(string) + "&specificversion=" + Utilities.safeEncode(string2);
        Utilities.logPrintln("... generalVersion = " + string);
        Utilities.logPrintln("... specificVersion = " + string2);
        Utilities.logPrintln("... additionalUrlString = " + string3);
        this.handleError(string3, "The Java Runtime Engine (JRE) is misconfigured.  Review the setup procedure for Packet Tracer Skills Assessments.", "AP-DA-001");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnMissingPatchFilesError(String string) {
        Utilities.logPrintln("missingPatchFilesError()");
        Utilities.logPrintln("\t\tmissingPatchFiles = " + string);
        this.handleError("ptaplayerpatchfilesmissing&missingfiles=" + string, "Required patch JAR files are missing: " + string, "AP-DA-005");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnNoJarFileError(String string) {
        Utilities.logPrintln("noJarFileError()");
        Utilities.logPrintln("\t\tmissingJarFile = " + string);
        this.handleError("ptaplayerjarmissing&missingfile=" + string, "Primary JAR file is missing: " + string, "AP-DA-002");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnNoPtHomeError() {
        Utilities.logPrintln("noPtHomeError()");
        this.handleError("nopackettracer", "Packet Tracer installation directory wasn't specified correctly", "AP-DA-003");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnNoRawFileError(String string) {
        return false;
    }

    protected boolean stopOnNoSecurityAccessError() {
        Utilities.logPrintln("noSecurityAccessError()");
        this.handleError("nosecurityaccess", "Packet Tracer Skills Assessment Player applet doesn't have sufficient security access to continue", "AP-DA-004");
        Utilities.logPrintln("\n==> void");
        return true;
    }

    protected boolean stopOnNoWorkerError() {
        return true;
    }
}

